from django.core.cache import cache
import json
from channels.layers import get_channel_layer
from channels.generic.websocket import AsyncWebsocketConsumer
from urllib.parse import urlparse,urlunparse
import time
import datetime
from django.core import serializers
from channels.db import database_sync_to_async
from .models import *

class ChatConsumer(AsyncWebsocketConsumer):
    async def generate_gpt_response(self,query,gpt_model,bot_id):
        res=""
        # import pinecone
        # from langchain.vectorstores import Pinecone
        # from langchain.embeddings import OpenAIEmbeddings
        # from langchain.llms import OpenAI
        # from langchain.chains.question_answering import load_qa_chain
        # from langchain.callbacks import get_openai_callback

        # pinecone.init(api_key="02daac6e-ba3d-410a-9580-2b4adc8f7e42",environment="gcp-starter")

        # embeddings_model=OpenAIEmbeddings(openai_api_key="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")

        # index_name = "xbot"
        # tokens_used=0

        # # First, check if our index already exists. If it doesn't, we create it
        # if index_name not in pinecone.list_indexes():
        #     # we create a new index
        #     pinecone.create_index(
        #     name=index_name,
        #     metric='cosine',
        #     dimension=1536
        # )
        # docsearch = Pinecone.from_existing_index("xbot", embeddings_model)
        # docs=docsearch.as_retriever(search_kwargs={'k': 2})
        # def get_docs(text):
        #     return docs.get_relevant_documents(
        #         text
        #     )
        # llm=OpenAI(openai_api_key="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",temperature=1)
        # chain = load_qa_chain(llm=llm, chain_type='stuff',verbose=True)
        # query=query
        # with get_openai_callback() as cb:
        #     res=chain.run(input_documents=get_docs(query),question=query)
        #     tokens_used=cb.total_tokens
        res="Bot res."
        return {
            "response":res,
            # "token_usage":tokens_used,
            "token_usage":5,
        }
    
    @database_sync_to_async
    def get_profile(self,profile_id):
        try:
            profile=Profile.objects.get(uid=profile_id)
            plans=cache.get("plans")
            if plans:
                plan=plans[profile.plan]
            else:
                plan=Plans.objects.get(type=profile.plan)
            params={
                "plan":profile.plan,
                "validity":profile.valid_till,
                "chat_credit":plan.chat_credit,
                "monthly_chat_credit":profile.monthly_chat_credit,
                "message_usage":profile.message_usage,
                "token_usage":profile.token_usage
            }
            return params
        except Exception as e:
            print(e)

    @database_sync_to_async
    def get_set_plans(self):
        plans={}
        try:
            data=list(Plans.objects.all())
            for plan in data:
                plans[plan.type]=plan
            cache.set("plans",plans)
        except Exception as e:
            print(e)
            import sys,os
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print("the real error is ",exc_type, fname, exc_tb.tb_lineno)
        return plans

    @database_sync_to_async
    def get_bot_conf(self,bot_id):
        try:
            bot=Bot.objects.get(uid=bot_id)
            return {
                "model":bot.model,
                "prompt":bot.prompt,
                "temperature":bot.temperature,
                "visibility":bot.visibility,
                "allowed_domains":bot.allowed_domains
            }
        except Exception as e:
            print(e)

    @database_sync_to_async
    def create_get_new_conversation(self,bot_id):
        try:
            bot=Bot.objects.get(uid=bot_id)
            conversation=Conversation(bot=bot)
            conversation.save()
            conv_id=str(conversation.uid)
            return {
                "conv_id":conv_id
            }
        except Exception as e:
            print(e)

    @database_sync_to_async
    def get_conversation(self,conv_id):
        try:
            conv=Conversation.objects.get(uid=conv_id)
            return {
                "conv":json.loads(serializers.serialize('json', [ conv ]))[0]["fields"]
            }
        except Exception as e:
            print(e)

    @database_sync_to_async
    def update_conversation(self, data):
        try:
            conv=Conversation.objects.get(uid=data["conv_id"])
            conv.name=data['name']
            conv.email=data['email']
            conv.profile_completed=data["profile_completed"]
            conv.messages=json.dumps(data['messages'])
            conv.total_messages=len(data['messages'])
            conv.incorrect_answers=data['incorrect_answers']
            conv.profile_completed=data['profile_completed']
            conv.other_info=data['other_info']
            conv.save()
            return None
        except Exception as e:
            print(e)

    async def host_to_url(self, host_str, default_scheme='http', default_path='/'):
        # If the host string doesn't contain a scheme, use the default_scheme
        if '://' not in host_str:
            host_str = f"{default_scheme}://{host_str}"

        # Add a default path if needed (you can modify this as needed)
        path = default_path

        # Parse the URL and ensure that the scheme is present
        url_parts = urlparse(host_str)
        if not url_parts.scheme:
            url_parts = urlparse(f"{default_scheme}://{host_str}")

        # Update the path if it's empty
        if not url_parts.path:
            url_parts = url_parts._replace(path=default_path)

        return urlunparse(url_parts)

    async def connect(self):
        try:
            #Get origin from header
            origin = dict(self.scope.get('headers', {})).get(b'host').decode('utf-8')
            #Change host name to proper url
            origin=urlparse(await self.host_to_url(origin)).hostname
            self.scope["session"]["origin"]=origin
            text_lst=self.scope['url_route']['kwargs']["id"].split('&')

            bot_id=text_lst[0]
            accept_connection=False
            self.scope['session'] = {
                "bot_id":bot_id,
                "admin_profile":"profile_"+text_lst[1],
                "last_message_at":""
            }
            profile=cache.get("profile_"+text_lst[1])
            if not profile:
                # profile=requests.post("http://127.0.0.1:8080/get-profile?id="+text_lst[1])
                profile=await self.get_profile(text_lst[1])

                cache.set("profile_"+text_lst[1],profile)
            else:
                profile=cache.get("profile_"+text_lst[1])

            active_users=cache.get_or_set(bot_id,{})

            if 'conf' not in active_users:
                conf=await self.get_bot_conf(bot_id)
                # req=requests.post("http://127.0.0.1:8080/get-bot-conf/",json={"bot_id":bot_id})
                model=conf["model"]
                active_users['conf']={
                    "model":model,
                    "prompt":conf["prompt"],
                    "temperature":conf["temperature"],
                    "visibility":conf['visibility'],
                    "allowed_domains":conf["allowed_domains"]
                }
            else:
                conf=active_users['conf']

            if datetime.date.today()<=profile['validity']:
                if conf['visibility']!='public' and origin in json.loads(conf["allowed_domains"]):
                    accept_connection=True
                elif conf['visibility']=='public':
                    accept_connection=True
                else:
                    accept_connection=False
                    
                if origin=="app.gpt-business.app":
                    accept_connection=True
                  
            if accept_connection:
                await self.accept()
                
                active_users[self.channel_name]={"name":"","messages":[],"total_messages":0,"started_at":datetime.datetime.now().strftime('%m/%d/%Y %H:%M:%S')}

                cache.set(bot_id, active_users)
                await self.send(text_data=json.dumps({
                    'status':200,
                    'type':'system'
                }))
            else:
                self.close()
        except Exception as e:
            print(e)
            import sys,os
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print("the real error is ",exc_type, fname, exc_tb.tb_lineno)
    
    async def chat_message(self, event):
        await self.send(event['data'])

    async def websocket_close(self, event):
        await self.close()

    async def receive(self,text_data):
        text_data_json=json.loads(text_data)
        channel_layer = get_channel_layer()
        bot_id=self.scope["session"]["bot_id"]
        try:
            if "system" in text_data_json and text_data_json["system"]:
                if "init_setup" in text_data_json and text_data_json["init_setup"]:
                    conv_id=""
                    #form data for profile completion
                    user_name=''
                    email=''
                    other_info="{}"
                    profile_completed=False
                    active_users=cache.get(bot_id)
                    incorrect_answers=0

                    if "conv_id" in text_data_json and text_data_json["conv_id"]!="" and "admin" not in text_data_json:
                        #Fetch and set all previous conversation's data
                        conv_id=text_data_json['conv_id']
                        # conv=requests.get("http://127.0.0.1:8080/get-conversation?conv_id="+text_data_json["conv_id"])
                        # conv=json.loads(conv.json()['conv'])[0]['fields']
                        conv=await self.get_conversation(conv_id)
                        conv=conv['conv']
                        user_name=conv['name']
                        email=conv['email']
                        other_info=conv["other_info"]
                        profile_completed=conv["profile_completed"]
                        active_users[self.channel_name]['messages']=json.loads(conv['messages'])
                        active_users[self.channel_name]['conv_conf']={
                            "liked":conv['liked'],
                            "bookmarked":conv['bookmarked'],
                            }
                        incorrect_answers=conv['incorrect_answers']
                    else:
                        if "admin" not in text_data_json:
                            # conv=requests.get("http://127.0.0.1:8080/create-conversation?bot_id="+bot_id)
                            conv=await self.create_get_new_conversation(bot_id)
                            conv_id=conv["conv_id"]
                        user_name=text_data_json['name']
                        email=text_data_json['email']
                        if "other_info" in text_data_json:
                            other_info=text_data_json["other_info"]
                        incorrect_answers=0

                        if user_name!="" and email!="":
                            profile_completed=True
                        elif user_name!="":
                            user_name="Unknown"
                            email=""

                    self.scope["session"]["conv_id"]=conv_id
                    active_users[self.channel_name]['conv_id']=conv_id
                    #Update session with the name of the user
                    self.scope["session"]["user_name"]=user_name
                    active_users[self.channel_name]['name']=user_name
                    active_users[self.channel_name]['email']=email
                    active_users[self.channel_name]['other_info']=other_info
                    active_users[self.channel_name]['incorrect_answers']=incorrect_answers
                    active_users[self.channel_name]['profile_completed']=profile_completed
                    active_users[self.channel_name]["conv_id"]=conv_id
                    print(text_data_json)
                    if "admin" in text_data_json:
                        #Delete the old admin and add new one.
                        if "admin" in active_users:
                            if 'connected_user' in active_users["admin"]:
                                await channel_layer.send(active_users["admin"]['connected_user'], {
                                                "type": "chat.message",
                                                "data": json.dumps({
                                                    "admin_disconnected":True,
                                                    "type":"system"
                                                }),
                                            })
                            await channel_layer.send(
                                active_users["admin"]["channel_name"],
                                {
                                    "type": "websocket.close",
                                    "code": 1000,
                                }
                            )
                            del active_users["admin"]
                            
                        print("all admins ",active_users)
                        self.scope["session"]["is_admin"]=True
                        active_users['admin']={
                            "channel_name":self.channel_name
                            }
                        active_users[self.channel_name]['role']='admin'
                        cache.set(bot_id, active_users)
                        #Send message when an anonymous user connected. Must copy the active user in a new variable since it would effect the whole cache.
                        active_users_only=active_users
                        #Delete the configuration part since it does not have the same structure as the user's channels
                        del active_users_only['conf']
                        await self.send(json.dumps({"type":"system","active":active_users_only}))
                        active_users_only=''
                    else:
                        conv_id=""
                        conv_id=self.scope["session"]["conv_id"]
                        active_users[self.channel_name]['role']='user'
                        cache.set(bot_id, active_users)
                        #Send message when a new user comes and admin is connected and updated in redis cache
                        await self.send(json.dumps({"type":"system","chat":True,"conv_id":conv_id}))
                        if "admin" in active_users:
                            await channel_layer.send(active_users["admin"]["channel_name"], {
                                    "type": "chat.message",
                                    "data": json.dumps({
                                        "new_user_connected":True,
                                        "type":"system",
                                        "id":self.channel_name,
                                        "name":user_name,
                                        "email":email,
                                        "started_at":active_users[self.channel_name]["started_at"],
                                        "conv_id":conv_id,
                                        "conv_conf":active_users[self.channel_name]['conv_conf']
                                    }),
                                })

                #If admin demands to switch user
                if "admin" in text_data_json and "switch_user" in text_data_json:
                    #This random token is generated each time the admin switches its chat user. The user needs to verify this token in order to send message to the admin
                    #Chat token can be generated and used here
                    admin_name=self.scope["session"]["user_name"]
                    user_channel=text_data_json['user_channel']
                    active_users=cache.get(bot_id)
                    if 'connected_user' in active_users["admin"]:
                        await channel_layer.send(active_users["admin"]['connected_user'], {
                                    "type": "chat.message",
                                    "data": json.dumps({
                                        "admin_disconnected":True,
                                        "type":"system"
                                    }),
                                })
                    active_users[self.channel_name]['connected_user']=user_channel
                    active_users["admin"]['connected_user']=user_channel
                    self.scope["session"]["connected_user"]=user_channel
                    cache.set(bot_id, active_users)

                    #Send message back to the admin when user switched
                    await self.send(json.dumps({"type":"system","chat":True,"message_history":active_users[user_channel]['messages']}))

                    #Send system message to the user who is now connected to admin
                    await channel_layer.send(user_channel, {
                        "type": "chat.message",
                        "data": json.dumps({
                            "admin_connected":True,
                            "admin":{
                                "name":admin_name
                            },
                            "type":"system",
                            "channel_id":active_users['admin']["channel_name"]
                        }),
                    })

                #Runs when users say that an answer was not satisfying or incorrect.
                if "incorrect_answer_index" in text_data_json:
                    active_users[self.channel_name]['messages'][text_data_json["incorrect_answer_index"]]["correct"]=False
                    active_users[self.channel_name]['messages']["incorrect_answers"]+=1
            else:
                proceed=False
                last_message_at=self.scope["session"]['last_message_at']
                if last_message_at!='':
                    if (time.time()-last_message_at)>3:
                        proceed=True
                        self.scope["session"]['last_message_at']=time.time()
                    else:
                        print('not good to go.')
                else:
                    proceed=True
                    self.scope["session"]['last_message_at']=time.time()
                
                if proceed:
                    active_users=cache.get(bot_id)
                    msg=text_data_json["msg"]
                    #Set user channel name to add the messages to the user's message list not the admin list.
                    user_channel=''
                    
                    if "is_admin" in self.scope["session"]:
                        by="agent"
                        user_channel=text_data_json["send_to"]
                    else:
                        by="user"
                        user_channel=self.channel_name

                    if "messages" in active_users[user_channel]:
                        active_users[user_channel]["messages"].append({
                            "type":by,
                            "msg":msg,
                            "correct":True
                        })
                    else:
                        active_users[user_channel]["messages"]={
                            "type":by,
                            "msg":msg,
                            "correct":True
                        }

                    if "send_to" in text_data_json and text_data_json["send_to"]!="":
                        await channel_layer.send(text_data_json["send_to"], {
                                    "type": "chat.message",
                                    "data": json.dumps({
                                        "msg":text_data_json["msg"],
                                        "type":"bot"
                                    }),
                                })
                    else:
                        #Send data to remote function to generate OpenAI response
                        profile=cache.get(self.scope["session"]["admin_profile"])
                        plans=cache.get("plans")

                        #Check if user should get a response or not.
                        authorized_to_answer=False
                        if profile:
                            if not plans:
                                plans=await self.get_set_plans()

                            if plans[profile['plan']].context_token>profile['token_usage']:
                                authorized_to_answer=True
                            else:
                                authorized_to_answer=False
                        else:
                            authorized_to_answer=False

                        print("the profile data structure is ",profile)
                        
                        if authorized_to_answer:
                            total_chat_credit=profile['chat_credit']+profile["monthly_chat_credit"]
                            chat_usage=profile['message_usage']
                            if total_chat_credit<=chat_usage:
                                pass
                            else:
                                res=await self.generate_gpt_response(text_data_json["msg"],active_users['conf']['model'],bot_id)
                                token_usage=res["token_usage"]
                                res=res["response"]
                                await self.send(json.dumps({"type":"bot","msg":res}))
                                active_users[self.channel_name]["messages"].append({
                                    "type":"bot",
                                    "msg":res
                                })
                                print("old usage ",chat_usage)
                                if active_users['conf']['model']=='gpt-4':
                                    chat_usage+=20
                                    profile['message_usage']+=20
                                elif active_users['conf']['model']=='gpt-3.5-turbo-16k':
                                    chat_usage+=8
                                    profile['message_usage']+=8
                                else:
                                    chat_usage+=1
                                    profile['message_usage']+=1

                                # Set total context token usage
                                profile["token_usage"]+=token_usage
                                    
                                cache.set(self.scope["session"]["admin_profile"],profile)

                                unsaved_profiles=cache.get_or_set("unsaved_profiles",{})
                                
                                unsaved_profiles[self.scope["session"]["admin_profile"].split("_")[1]]={"chat_usage":chat_usage,"token_usage":profile["token_usage"]}
                                cache.set('unsaved_profiles',unsaved_profiles)
                    cache.set(bot_id, active_users)
        except Exception as e:
            # pass
            print(e)
            import sys,os
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print("the real error is ",exc_type, fname, exc_tb.tb_lineno)

    async def websocket_disconnect(self, message):
        try:
            bot_id=self.scope["session"]["bot_id"]
            active_users=cache.get(bot_id)
            if "admin" in active_users:
                channel_layer = get_channel_layer()
                admin_channel=active_users["admin"]['channel_name']
                if self.channel_name==admin_channel:
                    if 'connected_user' in active_users["admin"]:
                        await channel_layer.send(active_users["admin"]['connected_user'], {
                                        "type": "chat.message",
                                        "data": json.dumps({
                                            "admin_disconnected":True,
                                            "type":"system"
                                        }),
                                    })
                    del active_users["admin"]
                else:
                    # requests.post("http://127.0.0.1:8080/update-conversation/",json={"data":active_users[self.channel_name]})
                    await self.update_conversation(active_users[self.channel_name])
                    await channel_layer.send(admin_channel, {
                        "type": "chat.message",
                        "data": json.dumps({
                            "a_user_disconnected":True,
                            "type":"system",
                            "id":self.channel_name,
                        }),
                    })
            else:
                # requests.post("http://127.0.0.1:8080/update-conversation/",json={"data":active_users[self.channel_name]})
                await self.update_conversation(active_users[self.channel_name])
                    
            # unsaved_lst=cache.get_or_set("unsaved_messages",{})
            # active_users[self.channel_name]["total_messages"]=len(active_users[self.channel_name]['messages'])
            # if bot_id in unsaved_lst:
            #     unsaved_lst[bot_id].append(active_users[self.channel_name])
            # else:
            #     unsaved_lst[bot_id]=[active_users[self.channel_name]]
            # cache.set("unsaved_messages",unsaved_lst)
            del active_users[self.channel_name]
            cache.set(bot_id, active_users)
        except Exception as e:
            pass
            import sys,os
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print("the real error is ",exc_type, fname, exc_tb.tb_lineno)
        await super().websocket_disconnect(message)

