# your_project/your_app/signals.py
from django.db.models.signals import pre_delete
from django.dispatch import receiver
from django.conf import settings
from .models import Bot
import pinecone
from django.core.cache import cache
import stripe

stripe.api_key=settings.STRIPE_SECRET_KEY

# Delete 
@receiver(pre_delete, sender=Bot)
def Delete_bot(sender, instance, **kwargs):
    try:
        id=str(instance.uid)
        cache.delete(id)
        pinecone.init(api_key=settings.PINECONE_API_KEY, environment=settings.PINECONE_ENV)
        index = pinecone.Index(settings.KNOWLEDGE_BASE_INDEX_NAME)
        index.delete(filter={"bot":id})
    except Exception as e:
        print(e)

@receiver(pre_delete, sender=Bot)
def Delete_profile(sender, instance, **kwargs):
    try:
        id=str(instance.uid)
        if instance.stripe_customer_id!="":
            stripe.Customer.delete(instance.stripe_customer_id)
        cache.delete("profile_"+id)
    except Exception as e:
        print(e)