from django.urls import path
from main import views
from rest_framework_simplejwt import views as jwt_views

urlpatterns = [
    path('', views.index, name='index'),
    path('token/', jwt_views.TokenObtainPairView.as_view(), name ='token_obtain_pair'),
    path('token/refresh/', jwt_views.TokenRefreshView.as_view(), name ='token_refresh'),
    path('login/', views.custom_jwt_authentication,name ='login'),
    path('authenticate/',views.authenticate, name="authenticate"),
    path('bots-list/', views.bots_list,name ='bots_list'),
    path('bot-info/', views.bot_info,name ='bot_info'),
    path('get-bot-conf/',views.get_bot_conf,name="get_bot_conf"),
    path('handle-bot/',views.handle_bot,name="handle_bot"),
    path('update-database/', views.update_database,name ='update_database'),
    path('signup/', views.add_unverified,name ='signup'),
    path('verify-mail/', views.verify_email,name ='verify'),
    path('reset-password/', views.reset_password,name ='reset_password'),
    path('checkout/', views.checkout,name ='checkout'),
    path('stripe-webhook/', views.stripe_webhook,name ='stripe_webhook'),
    path('get-profile', views.get_profile,name ='get_profile'),
    path('get-credit-info/', views.get_credit_info,name ='get_credit_info'),
    path('client-dashboard/', views.client_dashboard,name ='client_dashboard'),
    path('validate-chat/', views.validate_chat, name='validate_chat'),
    #conversations
    path('all-conversations/', views.all_conversations,name ='all_conversations'),
    path('create-conversation', views.create_conversation,name ='create_conversation'),
    path('update-conversation/', views.update_conversation,name ='update_conversation'),
    path('get-conversation', views.get_conversation,name ='get_conversation'),
    path('delete-conversation/', views.delete_conversation,name ='delete_conversation'),
    path('kb/', views.kb,name ='kb'),
    #Create embeddings
    path('create-embeddings/', views.embeddings, name='embeddings'),
    #Stripe
    path('get-stripe-public-key/', views.get_stripe_public_key, name='get_stripe_public_key'),
    path('list-payment-methods/', views.list_payment_methods, name='list_payment_methods'),
    path('add-payment-method/', views.add_payment_method, name='add_payment_method'),
    path('change-default-payment-method/', views.change_default_payment_method, name='change_default_payment_method'),
    path('delete-payment-method/', views.delete_payment_method, name='delete_payment_method'),
    path('cancel-subscription/', views.cancel_subscription, name='cancel_subscription'),
    path('upgrade-plan/', views.upgrade_plan, name='upgrade_plan'),
    path('get-client-graph-data/', views.get_client_graph_data, name='get_client_graph_data'),
    path('get-admin-profile/', views.get_admin_profile, name='get_admin_profile'),
    #super user
    path('superuser-dashboard/',views.super_user_dashboard, name="super_user_dashboard"),
    path('superuser-billing/',views.super_user_billing, name="super_user_billing"),
    path('superuser-charts/',views.super_user_charts, name="super_user_charts"),
    path('change-superuser-api-keys/',views.change_superuser_api_keys, name="change_superuser_api_keys"),
]